#! /usr/bin/env python
import os
import sys
import string
import datetime
import time
import math
import sidereal

Pi= math.pi
AU = 149597870.691
sin = math.sin
cos = math.cos
atan2 = math.atan2
sqrt = math.sqrt
asin = math.asin
acos = math.acos
pow = math.pow
DCOS = math.cos
DSIN = math.sin
deg2rad = math.radians
rad2deg = math.degrees

def rad_2_deg(x):
	y = 180.0 / 3.1415926535898 * x
	return y

def deg_2_rad(x):
	y = 3.1415926535898 / 180.0 * x
	return y

def deltaa(tetaa):
	xde = tetaa
	deltaa = 180 / 3.1415926535898 * atan2(xde, pow((-xde * xde + 1),0.5))
	return deltaa

def alfaa(etaa, tetaa, dzetaa):
	xal = etaa / cos(3.1415926535898 / 180 * deltaa(tetaa))
	alfaa = 180 / 3.1415926535898 * atan2(xal, pow((-xal * xal + 1),0.5))
	if dzetaa < 0: 
		alfaa = -alfaa + 180
	return alfaa

def Xgeo(fir, lambdar, heigr, yeargr, montgr, daygr, h,m,s):
	locsit = LSTI(yeargr, montgr, daygr, h,m,s, lambdar)
	er = radius(fir)
	gf = geofi(fir)
	he = heigr / 1000
	Xgeo = (er + he) * cos(math.radians(gf)) * cos(math.radians(locsit))
	return Xgeo

def Ygeo(fiq, lambdaq, heigq, yeargq, montgq, daygq, h,m,s):
	locsit = LSTI(yeargq, montgq, daygq, h,m,s, lambdaq)
	er = radius(fiq)	
	gf = geofi(fiq)
	he = heigq / 1000
	Ygeo = (er + he) * cos(math.radians(gf)) * sin(math.radians(locsit))
	return Ygeo

def Zgeo(fip, heigp):
	er = radius(fip)
	gf = geofi(fip)
	he = heigp / 1000.0
	Zgeo = (er + he) * sin(math.radians(gf))
	return Zgeo
	
def LSTI(Y,M,D,h,m,s,l):
	#czas gwiazdowy w oparciu o sidereal.py
	tim = datetime.datetime(Y,M,D,h,m,s)
	gsid = sidereal.SiderealTime.fromDatetime(tim)
	lsid = gsid.lst(math.radians(l))
	#konwersja
	lsid = str(lsid)
	h_,m_,s_ = string.split(lsid)
	h_ = int(h_[1:-1])
	m_ = int(m_[:-1])
	s_ = float(s_[:-2])
	lsid = (h_+m_/60.0+s_/3600.0) * 15
	return lsid
	
def radius(fi):
	firad = 3.1415926535898 / 180.0 * fi
	radius = (40680669.86 * (1 - 0.0133439554 * sin(firad) ** 2) / (1 - 0.006694385096 * sin(firad) ** 2)) ** 0.5
	return radius
	
def geofi(fi):
	firad = deg2rad(fi)
	geofi = fi - 0.1924240867 * sin(2 * firad) + 0.000323122 * sin(4 * firad) - 0.0000007235 * sin(6 * firad)
	return geofi
	
def fbheight(fi, rh):
	rr = radius(fi)
	fbheight = rh - rr
	return fbheight

def menu_tools():
	
	os.system("clear")
	print '================================================================================'
	print ' Qab optimizer                      QAB.PY                                      '
	print '================================================================================'
	print ''
	print '--------------------------------------------------------------------------------'
	print ' This application creates Qab intersection angle map for two stations and given '
	print ' radiant '
	print ' Required input data: lat/lon of two stations,'
	print ' radiant RA,Dec, Date, UT, assumed meteor heights'
	print ' Output is displayed using Gnuplot and is stored in Qab_optimizer_A.dat'
	print ' and Qab_optimizer_B.dat files.'
	print ' '
	print '--------------------------------------------------------------------------------'
	print ''
	print ' 1) Qab optimizer'.ljust(10)
	print ''
	print ' 2) Quit'.ljust(10)
	print ''
	print ''

	opt = raw_input(" Select option and press enter: ")
	if opt == '1':
		QAB_A = open("Qab_optimizer_A.dat", "w")
		QAB_B = open("Qab_optimizer_B.dat", "w")
		os.system("clear")
		print ""
		print " Intersection angle optimiser "
		print ""
		print " Calculates Qab map for 2 given stations and radiant"
		print ""
		print "----------------------------------------------------"
		print " "
		ind = raw_input(" Station A - latitude [-90,90]: ")
		Afi = float(ind)
		ind = raw_input(" Station A - longitude [W -180, 180 E]: ")
		Ala = float(ind)
		ind = raw_input(" Station B - latitude [-90,90]: ")
		Bfi = float(ind)
		ind = raw_input(" Station B - longitude [W -180, 180 E]: ")
		Bla = float(ind)
		ind = raw_input(" Radiant RA [0,360]: ")
		RadA = float(ind)
		ind = raw_input(" Radiant Dec [-90,90]: ")
		RadD = float(ind)
		ind = raw_input(" Year [yyyy]: ")
		sim_Y = int(ind)
		ind = raw_input(" Month [mm]: ")
		sim_M = int(ind)
		ind = raw_input(" Day [dd]: ")
		sim_D = int(ind)
		ind = raw_input(" UT hour [hh]: ")
		sim_h = int(ind)
		ind = raw_input(" UT minute [mm]: ")
		sim_m = int(ind)
		ind = raw_input(" Typical beginning height [km]: ")
		sim_hbeg = int(ind)
		ind = raw_input(" Typical terminal height [km]: ")
		sim_hend = int(ind)
		# wyznaczanie pozycji stacji A
		
		X_a = Xgeo(Afi,Ala,0,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
		Y_a = Ygeo(Afi,Ala,0,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
		Z_a = Zgeo(Afi,0)
		
		print ""
		print " Station A XYZ: ",X_a,Y_a,Z_a
		
		# wyznaczanie pozycji stacji B
		
		X_b = Xgeo(Bfi,Bla,0,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
		Y_b = Ygeo(Bfi,Bla,0,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
		Z_b = Zgeo(Bfi,0)
		
		print ""
		print " Station B XYZ: ",X_b,Y_b,Z_b
		print ""
		
		#generowanie meteorow
		
		Fic = (Afi + Bfi)/2.0
		Lac = (Ala + Bla)/2.0
		Fic = int(Fic)*10
		Lac = int(Lac)*10
		
		print ''
		print 'please wait...'
		print ''
		for fi_simet in range ((Fic - 50),(Fic + 50)):
			for la_simet in range ((Lac - 100),(Lac + 100)):
				fi_meteor = fi_simet/10.0
				la_meteor = la_simet/10.0
				
				#koniec meteoru
				
				X_en = Xgeo(fi_meteor,la_meteor,sim_hend,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
				Y_en = Ygeo(fi_meteor,la_meteor,sim_hend,sim_Y,sim_M,sim_D,sim_h,sim_m,0)
				Z_en = Zgeo(fi_meteor,sim_hend)
				
				# wektor na radiant
				dzeta_sim = math.cos(deg2rad(RadD)) * math.cos(deg2rad(RadA))
				eta_sim = math.cos(deg2rad(RadD)) * math.sin(deg2rad(RadA))
				teta_sim = math.cos(deg2rad(RadD))
				
				#poczatek meteoru
				l = 0
				met_height = 0
				while (met_height < sim_hbeg):
					l = l+1
					X = X_en + dzeta_sim * l
					Y = Y_en + eta_sim * l
					Z = Z_en + teta_sim * l
					promien = (X**2 + Y**2 + Z**2)**0.5
					met_height = fbheight(fi_meteor, promien)
				#print "Meteor begin: ",X,Y,Z,met_height
				X_be = X
				Y_be = Y
				Z_be = Z
				
				#wektor stacja A - poczatek meteoru
				
				X_metbeg_A = X_be - X_a
				Y_metbeg_A = Y_be - Y_a
				Z_metbeg_A = Z_be - Z_a
				
				A_metbeg_l = (X_metbeg_A**2 + Y_metbeg_A**2 + Z_metbeg_A**2)**0.5
				dz_b_A = X_metbeg_A/A_metbeg_l
				e_b_A = Y_metbeg_A/A_metbeg_l
				t_b_A = Z_metbeg_A/A_metbeg_l
				
				
				#wektor stacja A - koniec meteoru
				
				X_metend_A = X_en - X_a
				Y_metend_A = Y_en - Y_a
				Z_metend_A = Z_en - Z_a
				
				A_metend_l = (X_metend_A**2 + Y_metend_A**2 + Z_metend_A**2)**0.5
				dz_e_A = X_metend_A/A_metend_l
				e_e_A = Y_metend_A/A_metend_l
				t_e_A = Z_metend_A/A_metend_l
				
				#wektor stacja B - poczatek meteoru
				
				X_metbeg_B = X_be - X_b
				Y_metbeg_B = Y_be - Y_b
				Z_metbeg_B = Z_be - Z_b
				
				B_metbeg_l = (X_metbeg_B**2 + Y_metbeg_B**2 + Z_metbeg_B**2)**0.5
				dz_b_B = X_metbeg_B/B_metbeg_l
				e_b_B = Y_metbeg_B/B_metbeg_l
				t_b_B = Z_metbeg_B/B_metbeg_l
				
				#wektor stacja B - koniec meteoru
				
				X_metend_B = X_en - X_b
				Y_metend_B = Y_en - Y_b
				Z_metend_B = Z_en - Z_b
				
				B_metend_l = (X_metend_B**2 + Y_metend_B**2 + Z_metend_B**2)**0.5
				dz_e_B = X_metend_B/B_metend_l
				e_e_B = Y_metend_B/B_metend_l
				t_e_B = Z_metend_B/B_metend_l
				
				#Ceplecha (11) A
				
				sum_dzeta_eta = dz_b_A * e_b_A + dz_e_A + e_e_A
				sum_eta_teta = e_b_A * t_b_A + e_e_A * t_e_A
				sum_etakwadrat = e_b_A**2 + e_e_A**2
				sum_dzeta_teta = dz_b_A * t_b_A + dz_e_A * t_e_A
				
				sum_dzetakwadrat = dz_b_A**2 + dz_e_A**2
				
				A_a_ = sum_dzeta_eta * sum_eta_teta - sum_etakwadrat * sum_dzeta_teta
				A_b_ = sum_dzeta_eta * sum_dzeta_teta - sum_dzetakwadrat * sum_eta_teta
				A_c_ = sum_dzetakwadrat * sum_etakwadrat - sum_dzeta_eta**2
				A_d_ = (A_a_**2 + A_b_**2 + A_c_**2)**0.5
				
				a_A = A_a_ / A_d_
				b_A = A_b_ / A_d_
				c_A = A_c_ / A_d_
				
				
				#Ceplecha (11) B
				
				sum_dzeta_eta = dz_b_B * e_b_B + dz_e_B + e_e_B
				sum_eta_teta = e_b_B * t_b_B + e_e_B * t_e_B
				sum_etakwadrat = e_b_B**2 + e_e_B**2
				sum_dzeta_teta = dz_b_B * t_b_B + dz_e_B * t_e_B
				
				sum_dzetakwadrat = dz_b_B**2 + dz_e_B**2
				
				B_a_ = sum_dzeta_eta * sum_eta_teta - sum_etakwadrat * sum_dzeta_teta
				B_b_ = sum_dzeta_eta * sum_dzeta_teta - sum_dzetakwadrat * sum_eta_teta
				B_c_ = sum_dzetakwadrat * sum_etakwadrat - sum_dzeta_eta**2
				B_d_ = (A_a_**2 + A_b_**2 + A_c_**2)**0.5
				
				a_B = B_a_ / B_d_
				b_B = B_b_ / B_d_
				c_B = B_c_ / B_d_
				
				#Ceplecha (15)
				
				d = ((b_A * c_B - b_B * c_A)**2 + (a_B * c_A - a_A * c_B)**2 + (a_A * b_B - a_B * b_A)**2) ** 0.5
				
				#Ceplecha (14)
				
				dzeta_r = (b_A * c_B - b_B * c_A) / d
				eta_r = (a_B * c_A - a_A * c_B) / d
				teta_r = (a_A * b_B - a_B * b_A) / d
				
				#Ceplecha (16)
				cosq = (math.fabs(a_A*a_B+b_A*b_B+c_A*c_B))/pow(((a_A*a_A+b_A*b_A+c_A*c_A)*(a_B*a_B+b_B*b_B+c_B*c_B)),0.5)
				Qab = math.degrees(acos(cosq))
				#print "Planes intersection angle Qab:  ",Qab
				
				#RA,dec, stacja A
				
				dzetar = dz_b_A
				etar = e_b_A
				tetar = t_b_A
				
				
				met_alfa = alfaa(etar,tetar,dzetar)
				met_delta = deltaa(tetar)
				if met_alfa < 0:
					met_alfa = met_alfa + 360
				if met_alfa > 360:
					met_alfa = met_alfa - 360
	
				# test wysokosci radiantu:
				radiant_position = sidereal.RADec(deg_2_rad(met_alfa),deg_2_rad(met_delta))
				timr = datetime.datetime(int(sim_Y),int(sim_M),int(sim_D),int(sim_h),int(sim_m),int(0))
				ha = radiant_position.hourAngle(timr,(deg_2_rad(Ala)))
				altz = radiant_position.altAz(ha,(deg_2_rad(Afi)))
				rad_altitude = rad_2_deg(altz.alt)
				rad_azimuth = rad_2_deg(altz.az)
				
				#print "Station A: Alt, Az, Qab",rad_altitude,rad_azimuth,Qab
				lin = str(rad_azimuth) + " " + str(rad_altitude) + " " + str(Qab)+ "\n"
				QAB_A.write(lin)
				
				
				#RA,dec, stacja B
				
				dzetar = dz_b_B
				etar = e_b_B
				tetar = t_b_B
				
				
				met_alfa = alfaa(etar,tetar,dzetar)
				met_delta = deltaa(tetar)
				if met_alfa < 0:
					met_alfa = met_alfa + 360
				if met_alfa > 360:
					met_alfa = met_alfa - 360
	
				# test wysokosci radiantu:
				radiant_position = sidereal.RADec(deg_2_rad(met_alfa),deg_2_rad(met_delta))
				timr = datetime.datetime(int(sim_Y),int(sim_M),int(sim_D),int(sim_h),int(sim_m),int(0))
				ha = radiant_position.hourAngle(timr,(deg_2_rad(Bla)))
				altz = radiant_position.altAz(ha,(deg_2_rad(Bfi)))
				rad_altitude = rad_2_deg(altz.alt)
				rad_azimuth = rad_2_deg(altz.az)
				
				#print "Station B: Alt, Az, Qab",rad_altitude,rad_azimuth,Qab
				lin = str(rad_azimuth) + " " + str(rad_altitude) + " " + str(Qab)+ "\n"
				QAB_B.write(lin)
		tmp = raw_input(" Press enter to view station A results: ")
		os.system("gnuplot QabA.gp")
		tmp = raw_input(" Press enter to view station B results: ")
		os.system("gnuplot QabB.gp")
				
		
		
		tmp = raw_input(" Press enter to continue: ")
		
		QAB_A.close()
		QAB_B.close()
		
		
		
	elif opt =='2':
		os.system('clear')
		print ' =^..^='
		print ' written by P. Zoladek, Polish Fireball Network '
		print ' http://www.pkim.org'
		print ''
		print ' created with sidereal.py module '
		print ' http://www.nmt.edu/tcc/help/lang/python/examples/sidereal/index.html'
		print ''
		print ''
		sys.exit()
	else:
		menu_main()
	menu_main()
	
def menu_main():
	menu_tools()
	
menu_main()